# 📋 ОТЧЁТ О РЕАЛИЗАЦИИ IT-ПРОЕКТА

GitHub репозиторий: [Ссылка на репозиторий](https://github.com/NewSarcasmProvider/Web--based-slideshow/tree/feature/add-interactive-test?tab=readme-ov-file)
Live демо: [Ссылка на GitHub Pages](https://newsarcasmprovider.github.io/Web--based-slideshow/)

## 1. Общая характеристика проекта

**Название проекта:**  
Веб-глоссарий по методологии SCRUM с интерактивной системой тестирования  
в образовательном процессе

**Цель проекта:**  
Разработка веб-ориентированного образовательного продукта, направленного на изучение ключевых терминов методологии SCRUM и проверку усвоения материала с помощью интерактивного тестирования.

**Актуальность проекта:**  
Методология SCRUM широко применяется в современных IT-командах и всё чаще включается в образовательные программы. Однако теоретическое изучение терминов без практической проверки знаний снижает эффективность обучения. Реализация интерактивного тестирования позволяет повысить вовлечённость обучающихся и обеспечить объективную оценку уровня усвоения материала.

**Исходное состояние системы:**
- статический глоссарий, реализованный в виде 10 слайдов;
- линейная навигация между слайдами;
- отсутствие интерактивных элементов;
- невозможность самопроверки знаний.

Таким образом, исходная версия продукта выполняла лишь справочную функцию и имела ограниченную образовательную ценность.

---

## 2. Управление проектом с использованием методологии SCRUM

Для организации разработки была выбрана методология **SCRUM**, как наиболее подходящая для итеративного развития IT-продуктов.

### Планирование и анализ (Sprint 1)

**Длительность спринта:** 2 дня  

В рамках первого спринта были выполнены следующие действия:
- анализ текущего состояния веб-глоссария;
- выявление функциональных и образовательных недостатков;
- формирование продуктового бэклога.

Ключевая проблема была сформулирована как отсутствие механизма проверки знаний.  
На основании этого в системе управления проектом GitHub был создан запрос на доработку:

**Issue #1:** «Добавить интерактивный тест для проверки знаний терминов SCRUM».

### Формирование требований к новой функциональности

В результате анализа были определены следующие требования:
- наличие не менее 10 вопросов;
- использование различных типов заданий для комплексной оценки знаний;
- автоматический подсчёт результатов;
- отображение итогов тестирования;
- адаптация интерфейса под разные устройства.

Применение SCRUM позволило чётко определить объём работ, зафиксировать требования и обеспечить прозрачность разработки.

---

## 3. Организация разработки и стратегия ветвления

Для управления версиями проекта использовалась стратегия **Feature Branch Workflow**, являющаяся частью практик Git Flow.

### Причины выбора стратегии
- изоляция разработки новой функциональности;
- сохранение стабильности основной ветки `main`;
- удобство код-ревью и контроля качества.

### Процесс разработки

Работа над новой функциональностью велась в отдельной ветке: `feature/add-interactive-test`


Особенности процесса:
- все изменения выполнялись исключительно в feature-ветке;
- использовались регулярные коммиты с осмысленными сообщениями;
- после завершения разработки был создан Pull Request;
- проведена проверка корректности реализации;
- после утверждения изменения были слиты в `main`, а feature-ветка удалена.

Данный подход обеспечил управляемость разработки и чистоту репозитория.

---

## 4. Реализация интерактивной системы тестирования

### Архитектурные решения

Приложение реализовано с использованием модульной архитектуры на JavaScript (ES6).  
Основные компоненты системы:
- `App` — инициализация приложения;
- `SlidesManager` — управление отображением глоссария;
- `TestManager` — управление логикой тестирования.

Разделение ответственности между модулями повысило читаемость кода и упростило дальнейшее расширение системы.

### Реализация тестирования

Система тестирования включает **10 вопросов**, реализованных в трёх форматах:

- **Множественный выбор (7 вопросов)**  
  Используется для проверки понимания основных понятий SCRUM.

- **Сопоставление (1 вопрос)**  
  Направлено на формирование связей между терминами и их определениями.

- **Заполнение пропусков (2 вопроса)**  
  Проверяет точность знания формулировок.

### Пользовательский интерфейс

Интерфейс тестирования состоит из трёх логических экранов:
1. экран начала теста;
2. экран прохождения вопросов;
3. экран отображения результатов.

Реализованы:
- индикатор прогресса;
- визуальная обратная связь;
- адаптивный дизайн для настольных и мобильных устройств.

---

## 5. Планирование и анализ временных затрат

Общая оценка трудозатрат составила **30 часов**, что полностью соответствует фактическому времени выполнения проекта.

| Этап работы | План | Факт |
|------------|------|------|
| Анализ и планирование | 4 ч | 4 ч |
| Настройка окружения | 2 ч | 2 ч |
| Разработка тестирования | 15 ч | 16 ч |
| Интеграция и тестирование | 6 ч | 6 ч |
| Документация | 3 ч | 2 ч |

Небольшое превышение времени на разработку компенсировано сокращением времени на документацию за счёт хорошо организованной структуры проекта.

---

## 6. Результаты реализации проекта

### Функциональные результаты
- реализована интерактивная система тестирования;
- обеспечена комплексная проверка знаний;
- сохранена и расширена исходная функциональность глоссария.

### Технические результаты
- модульная архитектура;
- современный стек веб-технологий;
- совместимость с актуальными браузерами;
- соблюдение практик командной разработки.

### Образовательные результаты
- повышение вовлечённости обучающихся;
- возможность самоконтроля знаний;
- повышение эффективности усвоения терминологии SCRUM.

---

## 7. Выводы

В ходе выполнения проекта была успешно применена методология SCRUM и стратегия Feature Branch Workflow. Добавление интерактивной системы тестирования трансформировало веб-глоссарий из пассивного справочного ресурса в полноценный образовательный инструмент.

Проект соответствует поставленным целям, готов к размещению на GitHub Pages и может быть использован в образовательном процессе при изучении методологии SCRUM.

